SET SQL_SAFE_UPDATES=0;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EVENT_COURSE_REGISTRATION_END_REMINDER_RECIPIENTS');

UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT DISTINCT
    T3.userId AS ID,
    T6.programNameToBePrint AS PROGRAM_NAME,
    T4.printName AS STUDENT_NAME,
    T5.batchName AS BATCH_NAME,
    T7.printName AS PERIOD_NAME,
T11.itemValue As REGISTRATION_TERM,
DATE(T10.studentStartDateTime) AS TERM_STUDENT_START_DATE,
DATE(T10.studentEndDateTime) AS TERM_STUDENT_END_DATE,
DATE_FORMAT(T10.studentStartDateTime, '%h:%i %p') AS TERM_STUDENT_START_TIME,
    DATE_FORMAT(T10.studentEndDateTime, '%h:%i %p') AS TERM_STUDENT_END_TIME,
p.emailId AS EMAIL_ID,
T8.academyName AS ACADEMY_NAME,
@@system_time_zone AS TIME_ZONE,
     T4.printName as USERNAME,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.middleName AS MIDDLE_NAME,
    p.lastName AS LAST_NAME,
     p.alternateEmailId as ALTERNATE_EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    CONVERT(FROM_BASE64(T4.passwordBase64) USING utf8) AS PASSWORD,
    T4.code AS STUDENT_ID,
    T19.itemValue AS ACADEMIC_TERM,
    T20.itemValue AS INTAKE_YEAR,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_LOCATION,
    T13.phoneCountryCode as PHONE_COUNTRY_CODE,
    T13.phoneAreaCode as PHONE_AREA_CODE,
    T13.phoneNo as PHONE_NUMBER,
    T13.cellCountryCode as MOBILE_COUNTRY_CODE,
    T13.cellNo as MOBILE_NUMBER,
    T13.primaryeEmailId as PRIMARY_MAIL_ID,
    T13.alternateEmailId as ALTERNATE_MAIL_ID,
    st.seatName as SEAT_TYPE,
 (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case
        when
            T8.footerUrl is not null
                and org.orgUrl IS NOT NULL
        then
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL
    end) as FOOTER_URL,
addr.websiteURL AS ACADEMY_LOCATION_URL
FROM
    program_batch_students T1
        LEFT JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT JOIN
    users T4 ON T3.userId = T4.id
        LEFT JOIN
    batches T5 ON T1.programBatchId = T5.id
        LEFT JOIN
    programs T6 ON T5.programId = T6.id
        LEFT JOIN
    prog_batch_period_config T7 ON T1.progBatchPeriodConfigId = T7.id
        LEFT JOIN
    registration_term_setup_detail T9 ON T7.registrationTermSetupDetailId = T9.id
        LEFT JOIN
    term_wise_course_registration T10 ON T9.id = T10.registrationTermSetupDetailId
        LEFT JOIN
      registration_term T11 ON T10.registrationTermId = T11.id
        LEFT JOIN
    persons p ON p.id = T3.personId
        LEFT JOIN
    academy_location T8 ON T8.id = T6.academyLocationId
        LEFT OUTER JOIN
     academy_location_addresses ala on ala.academyLocationId = T8.id
	LEFT OUTER JOIN
     address addr on addr.id = ala.addressId
        LEFT OUTER JOIN
     locations loc on loc.id = T8.locationId
	LEFT OUTER JOIN
     location_addresses locadd ON locadd.locationId = loc.id
        LEFT JOIN
    address T13 ON T13.id = locadd.addressId
        LEFT OUTER JOIN
    city T14 ON T14.id = T13.cityId
        LEFT OUTER JOIN
    country T15 ON T15.id = T14.countryId
        LEFT OUTER JOIN
    country_region T16 ON T16.id = T14.countryRegionId
        LEFT OUTER JOIN
    prog_batch_seat_config T17 ON T17.id = T1.progBatchSeatConfigId
        LEFT OUTER JOIN
	seat_types st on st.id = T17.seatTypeId
LEFT OUTER JOIN
academic_term T19 on T19.id = T7.academicTermId
LEFT OUTER JOIN
    intake_year T20 on T20.id = T5.intakeYearId
LEFT OUTER JOIN
    organizations org ON org.id = (SELECT
            MAX(id)
        FROM
            organizations)
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null AND 
    DATE(T10.studentEndDateTime) = DATE_FORMAT((DATE(NOW())),
            '%Y-%m-%d')
        AND T1.promotionEnrollmentStatus = 'PENDING' AND T3.userId in (namedParams)
GROUP BY T3.userId" ,
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
		{
            "id": 2,
            "value": "programNameToBePrint",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
		  {
            "id": 3,
            "value": "batchName",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PERIOD_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "itemValue",
            "resultKey": "REGISTRATION_TERM",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "studentStartDateTime",
            "resultKey": "TERM_STUDENT_START_DATE",
            "displayCode": "",
            "displayOrder": 5
        },{
            "id": 7,
            "value": "studentEndDateTime",
            "resultKey": "TERM_STUDENT_END_DATE",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "studentStartDateTime",
            "resultKey": "TERM_STUDENT_START_TIME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "studentEndDateTime",
            "resultKey": "TERM_STUDENT_END_TIME",
            "displayCode": "",
            "displayOrder": 8
        },{
            "id": 10,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "mobileCountryCode",
            "resultKey": "MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "@@system_time_zone",
            "resultKey": "TIME_ZONE",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },       
        {
            "id": 16,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        }, 
        {
            "id": 17,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION",
            "displayCode": "",
            "displayOrder": 17
        },
		{
            "id": 19,
            "value": "phoneCountryCode",
            "resultKey": "PHONE_COUNTRY_CODE",
            "displayCode": "",
            "displayOrder": 18
        },
		{
            "id": 20,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 19
        },
		{
            "id": 21,
            "value": "cellCountryCode",
            "resultKey": "MOBILE_COUNTRY_CODE",
            "displayCode": "",
            "displayOrder": 20
        },
		{
            "id": 22,
            "value": "cellNo",
            "resultKey": "MOBILE_NUMBER",
            "displayCode": "",
            "displayOrder": 21
        },
		{
            "id": 23,
            "value": "primaryeEmailId",
            "resultKey": "PRIMARY_MAIL_ID",
            "displayCode": "",
            "displayOrder": 22
        },
		{
            "id": 24,
            "value": "alternateEmailId",
            "resultKey": "ALTERNATE_MAIL_ID",
            "displayCode": "",
            "displayOrder": 23
        },
		{
            "id": 25,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 24
        },
		{
            "id": 26,
            "value": "printName",
            "resultKey": "USERNAME",
            "displayCode": "",
            "displayOrder": 25
        },
        {
            "id": 27,
            "value": "Password",
            "resultKey": "PASSWORD",
            "displayCode": "",
            "displayOrder": 26
        },
		{
            "id": 28,
            "value": "itemValue",
            "resultKey": "ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 27
        },
		{
            "id": 29,
            "value": "itemValue",
            "resultKey": "INTAKE_YEAR",
            "displayCode": "",
            "displayOrder": 28
        },
		{
            "id": 30,
            "value": "phoneAreaCode",
            "resultKey": "PHONE_AREA_CODE",
            "displayCode": "",
            "displayOrder": 29
        },
{
            "id": 31,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 30
        },
        {
            "id": 32,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 31
        },
        {
            "id": 33,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 32
        },
        {
            "id": 34,
            "value": "websiteURL",
            "resultKey": "ACADEMY_LOCATION_URL",
            "displayCode": "",
            "displayOrder": 33
        },
        {
            "id": 35,
            "value": "seatName",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 34
        }
    ]
}' WHERE (`dataProviderId` = @dtproviderId);

SET SQL_SAFE_UPDATES=1;